﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="SendToKitchen.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.POS.SendToKitchen" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>Kitchen Receipt</title>
    <link href="http://netdna.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css" rel="stylesheet" />
    <link href="../Styles/POS/bootstrap.min.css" rel="stylesheet" />
    <link href="../Styles/POS/POS-receipt-styles.css" rel="stylesheet">
    <script>
        
    </script>
</head>
<body>
    <form id="form1" runat="server">
        <div class="row pos-receipt-envelope">
            <table class="table borderless text-center pos-table">
                <tr>
                    <td align="center">
                        <img src="../Images/customer_logo.jpg" width="64" /></td>
                </tr>
                <tr>
                    <td><strong class="pos-receipt-receipt">KITCHEN RECEIPT</strong></td>
                </tr>
                <tr>
                    <td>
                        <hr class="pos-receipt-divider" />
                        <table class="table borderless text-left pos-table">
                            <tr>
                                <td>User</td>
                                <td>
                                    <asp:Literal runat="server" ID="lblReceiptCashier" /></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>Date</td>
                                <td><%= DateTime.Now.ToShortDateString() %></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>Time</td>
                                <td><%= DateTime.Now.ToString("hh:MM ss tt") %></td>
                                <td></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td>
                        <hr class="pos-receipt-divider" />
                        <table class="table borderless text-left pos-table">
                            <tr>
                                <td>Table #</td>
                                <td>
                                    <asp:Literal runat="server" ID="lblReceiptTableNumber" /></td>
                                <td></td>
                            </tr>
                        </table>
                        <hr class="pos-receipt-divider" />
                    </td>
                </tr>
                <tr>
                    <td>
                        <table class="table borderless text-left pos-table">
                            <tr>
                                <td class="text-center">Item</td>
                                <td class="text-center">Qty</td>
                                <td class="text-center">Size</td>
                            </tr>
                            <tr>
                                <td colspan="3">
                                    <hr class="pos-receipt-divider" />
                                </td>
                            </tr>
                            <asp:Repeater ID="rptProductsReceipt" runat="server" OnItemDataBound="rptProductsReceipt_ItemDataBound">
                                <ItemTemplate>
                                    <tr>
                                        <td  class="text-left">
                                            <%# Eval("ProductName") %>
                                        </td>
                                        <td  class="text-center">
                                            <%# Eval("Quantity") %>
                                        </td>
                                        <td  class="text-center">
                                            <asp:Label runat="server" data-ProductID='<%# Eval("ProductID") %>' ID="lblSizeName" />
                                        </td>
                                    </tr>
                                </ItemTemplate>
                            </asp:Repeater>
                            <tr>
                                <td colspan="4">
                                    <hr class="pos-receipt-divider" />
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td><label style="font-weight:bold;text-align:center;">Remarks</label><br />
                        <span id="lblRemarks" />
                    </td>
                </tr>
            </table>
        </div>
    </form>
    <script src="../Scripts/jquery.min.js"></script>
    <script src="../Scripts/vendor/bootstrap/bootstrap.min.js"></script>
    <script>
        $(document).ready(function () {
            var remarks = prompt("Please enter any remarks");
            $('#lblRemarks').text(remarks);
            window.print();
        });
    </script>
</body>
</html>
